
@echo off
mkdir build
pushd build

rem /MT - multithreaded
rem /Fasc - outputs assembly
rem /EHa - exception handling
rem /GR- - disables RTTI
rem /Z7 - debug information
rem /W4 - highest warning level
rem /Oi - generates intrinsic functions
rem /Fm - generates map file
rem /Fo - generates an object file
rem /FC - Displays the full path of source code files

set includes=/I "C:\dev\common-code" /I "C:\dev\decibell\src"
set warning_options=/W4 /wd4100 /wd4996 /wd4018 /wd4244 /wd4201 /wd4127 /wd4310 /wd4305 /wd4309 /wd4267 /wd4505 /wd4552 /wd4553 /wd4838 /wd4459 /wd4477
set opt_warning_options= %warning_options% /wd4189
set compiler_options= /Od /FC /Fasc /fp:fast /MT /EHa /GR- /Z7 /Oi /Fm /nologo %warning_options% %includes%
set opt_compiler_options= /O2 /FC /Fasc /fp:fast /MT /EHa /GR- /Z7 /Oi /Fm /nologo %opt_warning_options% %includes% /D NO_ASSERTS
set win_linker_options=/link /opt:ref /STACK:2097152 user32.lib winmm.lib gdi32.lib
set main_linker_options=/LD /link /opt:ref /STACK:2097152

set win_command=cl ..\src\win.cpp %preprocessor_options% %compiler_options% %win_linker_options%
set main_command=cl ..\src\main.cpp %preprocessor_options% %compiler_options% %main_linker_options%

del * /Q 2> NUL

start /b /realtime /wait %win_command%
start /b /realtime /wait %main_command%

popd

exit 
